#!/bin/bash

typeset jarFile=$1
typeset jarFileBasename=`basename $jarFile`

typeset base=deployMockJar
typeset baseShellScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments
typeset deployScript=${deploymentsDir}/${baseShellScript}

typeset envScript='../set.env.sh'

rm -f $errorLog
mkdir -p $deploymentsDir

if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > ${deployScript}
#!/bin/bash

typeset command="java -jar /vagrant/deployments/$1"

ps -ef | grep "java -jar /vagrant/deployments/MockServices" | grep -v grep | sed "s/[ ]\{1,\}/ /g" | cut -d" " -f2 | \
while read pid; do
	echo killing $pid ...
	kill -9 $pid
done

echo "Running $command ..."
$command &
EOF

chmod +x $deployScript
cp $jarFile $deploymentsDir

cd $VAGRANT_DIR
if [[ -f $envScript ]]; then
	. $envScript
fi
vagrant ssh vamf_weblogic --command "/vagrant/deployments/$baseShellScript $jarFileBasename > $deployLog 2>&1"
